/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */    
package com.ejie.p06b.util.bd;

import java.sql.Connection;

/**
 * Clase que gestiona las conexiones con la bd
 */
public class P06BServidorConexionesBD {

    private static P06BServidorConexionesBD cServidorConexiones = new P06BServidorConexionesBD();

    private P06BServidorConexionesBD() {   
    }
    
    
    /** Devuelve una conexin compartida a la base de datos. La conexion
     *  se encuentra permanentemente abierta, y puede ser usada por cualquier
     *  proceso pare realizar una consulta sobre la base de datos. Cada
     *  llamada a este mtodo devuelve la misma conexin independientemente
     *  de quien lo ejecute.
     *  @return Conexion a la base de datos.
     */
    public static Connection getConexionConsultas() {

        return new P06BConexionBD(true).obtenerConexion();
    }

    /** Devuelve una nueva conexin a la base de datos. La conexin se crea
     *  en el momento de la llamada al mtodo, y no se reutiliza para otros
     *  procesos. Cada llamada a este procedimiento devuelve una conexin distinta.
     *  El proceso llamante se debe encargar de cerrar la conexin al finalizar.
     *  @return Conexion a la base de datos.
     */
    public static Connection getConexionPrivada() {

        return new P06BConexionBD(true).obtenerConexion();
    }

}